import 'package:flutter/material.dart';
import 'package:flutter_riverpod/flutter_riverpod.dart';
import 'package:zabino/features/codex_solution/presentation/provider/state/text_field_state.dart';

BoxDecoration BoxDecorationCustom(TextFieldState state, String label) {
  return BoxDecoration(
    borderRadius: BorderRadius.circular(18),
    boxShadow: [
      label == state.selectedTextFieldName
          ? const BoxShadow(
              color: Colors.green,
              blurRadius: 0,
              spreadRadius: 2.5,
              offset: Offset(0, -2),
            )
          : const BoxShadow(
              color: Colors.blueGrey,
              blurRadius: 0,
              spreadRadius: 1.5,
              // offset: Offset(0, -2),
            ),
    ],
  );
}
