import 'package:flutter/cupertino.dart';
import 'package:flutter/foundation.dart';
import 'package:flutter/material.dart';

class ButtonAnimat extends StatefulWidget {
  const ButtonAnimat({
    super.key,
    this.colorShadow = Colors.black,
    required this.widgetChild,
    required this.containerColor,
    required this.boxShape,
    this.borderRadius,
    this.blurRadius = 4,
    this.spreadRadius = 1.5,
  });
  final Color? colorShadow;
  final Color containerColor;
  final BoxShape boxShape;
  final Widget widgetChild;
  final BorderRadius? borderRadius;
  final double? blurRadius;
  final double? spreadRadius;
  @override
  State<ButtonAnimat> createState() => _ButtonAnimatState();
}

class _ButtonAnimatState extends State<ButtonAnimat>
    with SingleTickerProviderStateMixin {
  bool onEnter = false;
  late final AnimationController _controller;

  @override
  void initState() {
    super.initState();
    _controller = AnimationController(
      vsync: this,
      duration: const Duration(seconds: 2),
    );
  }

  @override
  void dispose() {
    _controller.dispose();
    super.dispose();
  }

  @override
  Widget build(BuildContext context) {
    return MouseRegion(
      onEnter: (event) {
        setState(() {
          onEnter = true;
        });
        _controller.forward;
      },
      onExit: (event) {
        setState(() {
          onEnter = false;
        });
      },
      child: AnimatedBuilder(
        animation: _controller,
        builder: (_, child) {
          return Transform.scale(
            scaleX: onEnter ? 0.95 : 1,
            scaleY: onEnter ? 0.95 : 1,
            child: Container(
              height: 32,
              decoration: BoxDecoration(
                boxShadow: [
                  BoxShadow(
                    blurRadius: onEnter
                        ? clampDouble(widget.blurRadius! / 2, 0, 100)
                        : widget.blurRadius!,
                    spreadRadius: onEnter
                        ? clampDouble(widget.spreadRadius! / 3, 0, 100)
                        : widget.spreadRadius!,
                    offset: Offset(0, onEnter ? 0 : 4),
                    color: widget.colorShadow!,
                  ),
                ],
                borderRadius: widget.boxShape == BoxShape.rectangle
                    ? widget.borderRadius
                    : null,
                shape: widget.boxShape,
                color: widget.containerColor,
              ),
              child: widget.widgetChild,
            ),
          );
        },
      ),
    );
  }
}
