import 'package:flutter/cupertino.dart';
import 'package:flutter/material.dart';
import 'package:flutter_riverpod/flutter_riverpod.dart';
import 'package:go_router/go_router.dart';
import 'package:zabino/features/codex_solution/data/datasource/text_edit_name.dart';
import 'package:zabino/features/codex_solution/presentation/components/appbar_alert_dailog.dart';
import 'package:zabino/features/codex_solution/presentation/components/box_decoration_custom.dart';
import 'package:zabino/features/codex_solution/presentation/components/button_animate.dart';
import 'package:zabino/features/codex_solution/presentation/components/container_area_alert_dialog.dart';
import 'package:zabino/features/codex_solution/presentation/components/drop_down_menu_field_custom.dart';
import 'package:zabino/features/codex_solution/presentation/components/elevated_bottun_custom.dart';
import 'package:zabino/features/codex_solution/presentation/components/input_decoration_custom.dart';
import 'package:zabino/features/codex_solution/presentation/components/responsive_column_or_row.dart';
import 'package:zabino/features/codex_solution/presentation/components/text_field_custom.dart';
import 'package:zabino/features/codex_solution/presentation/provider/text_field_controller.dart';

class ContainerAddDriverAlertDailog extends ConsumerWidget {
  const ContainerAddDriverAlertDailog({super.key});

  @override
  Widget build(BuildContext context, ref) {
    final ThemeData themedata = Theme.of(context);

    final selectedTextField = ref.read(textFieldControllerProvider.notifier);
    return Padding(
      padding: const EdgeInsets.all(32),
      child: Container(
        decoration: BoxDecoration(
          borderRadius: BorderRadius.circular(18),
          color: themedata.colorScheme.surface,
        ),
        child: Padding(
          padding: const EdgeInsets.all(24),
          child: Column(
            children: [
              const Padding(
                padding: EdgeInsets.only(right: 8.0),
                child: AppBarAlertDailog(title: 'زیادکردنی شوفیر'),
              ),
              Expanded(
                child: SingleChildScrollView(
                  child: Padding(
                    padding: const EdgeInsets.all(8.0),
                    child: Column(
                      crossAxisAlignment: CrossAxisAlignment.start,
                      spacing: 16,
                      children: [
                        ResponsiveColumnOrRow(
                          widgetList: [
                            TexFieldCustom(
                              controller: TextEditingController(),
                              onTaped: (selectedTextFieldKey) =>
                                  selectedTextField.selectTexField(
                                    selectedTextFieldKey,
                                  ),
                              label: TextEditName.name,
                              prefixIcon: Icons.account_circle,
                            ),
                            TexFieldCustom(
                              controller: TextEditingController(),
                              keyboardType: TextInputType.phone,
                              onTaped: (selectedTextFieldKey) =>
                                  selectedTextField.selectTexField(
                                    selectedTextFieldKey,
                                  ),
                              label: TextEditName.mobile1,
                              prefixIcon: Icons.phone_in_talk_rounded,
                            ),
                          ],
                        ),
                        ResponsiveColumnOrRow(
                          widgetList: [
                            TexFieldCustom(
                              controller: TextEditingController(),
                              keyboardType: TextInputType.phone,
                              onTaped: (selectedTextFieldName) =>
                                  selectedTextField.selectTexField(
                                    selectedTextFieldName,
                                  ),
                              label: TextEditName.mobile2,
                              prefixIcon: Icons.phone_in_talk_rounded,
                            ),
                            TexFieldCustom(
                              controller: TextEditingController(),
                              label: TextEditName.area,
                              prefixIcon: Icons.map_rounded,
                              onTapDrapDown: () {
                                selectedTextField.selectTexField(
                                  TextEditName.area,
                                );
                                showDialog(
                                  context: context,
                                  builder: (context) {
                                    return ContainerAreaAlertDailog(
                                      themedata: themedata,
                                    );
                                  },
                                );
                              },
                              readOnly: true,
                            ),
                          ],
                        ),
                        ResponsiveColumnOrRow(
                          widgetList: [
                            TextFieldDropDownCustom(
                              controller: TextEditingController(),
                              onTaped: (selectedTextFieldName) {
                                selectedTextField.selectTexField(
                                  selectedTextFieldName,
                                );
                              },
                              label: TextEditName.supervisory,
                              prefixIcon: Icons.display_settings_rounded,
                            ),
                            TexFieldCustom(
                              controller: TextEditingController(),
                              key: Key(TextEditName.customerName),
                              onTaped: (selectedTextFieldKey) =>
                                  selectedTextField.selectTexField(
                                    selectedTextFieldKey,
                                  ),
                              label: TextEditName.customerName,
                              prefixIcon: Icons.account_circle,
                            ),
                          ],
                        ),
                        ResponsiveColumnOrRow(
                          widgetList: [
                            TexFieldCustom(
                              controller: TextEditingController(),
                              onTaped: (selectedTextFieldKey) =>
                                  selectedTextField.selectTexField(
                                    selectedTextFieldKey,
                                  ),
                              label: TextEditName.letter,
                              prefixIcon: Icons.lock,
                            ),
                            const SizedBox(),
                          ],
                        ),
                        ResponsiveColumnOrRow(
                          widgetList: [
                            InkWell(
                              onTap: () {},
                              child: Container(
                                width: double.infinity,
                                decoration: BoxDecoration(
                                  borderRadius: BorderRadius.circular(16),
                                  border: Border.all(
                                    color: Colors.grey,
                                    width: 2,
                                  ),
                                ),
                                child: const Padding(
                                  padding: EdgeInsets.all(16.0),
                                  child: Column(
                                    spacing: 16,
                                    children: [
                                      Text('وینه'),
                                      Icon(Icons.person),
                                    ],
                                  ),
                                ),
                              ),
                            ),
                            InkWell(
                              onTap: () {},
                              child: Container(
                                width: double.infinity,
                                decoration: BoxDecoration(
                                  borderRadius: BorderRadius.circular(16),
                                  border: Border.all(
                                    color: Colors.grey,
                                    width: 2,
                                  ),
                                ),
                                child: const Padding(
                                  padding: EdgeInsets.all(16.0),
                                  child: Column(
                                    spacing: 16,
                                    children: [
                                      Text('وینه‌ی ناسنامه'),
                                      Icon(Icons.medical_information),
                                    ],
                                  ),
                                ),
                              ),
                            ),
                          ],
                        ),
                        TexFieldCustom(
                          key: Key(TextEditName.description),
                          controller: TextEditingController(),
                          onTaped: (selectedTextFieldKey) => selectedTextField
                              .selectTexField(selectedTextFieldKey),
                          label: TextEditName.description,
                          prefixIcon: CupertinoIcons.captions_bubble,
                          maxLine: 3,
                        ),

                        Row(
                          mainAxisAlignment: MainAxisAlignment.spaceBetween,
                          crossAxisAlignment: CrossAxisAlignment.center,
                          spacing: 15,
                          children: [
                            ButtonAnimat(
                              widgetChild: Tooltip(
                                message: 'clear text field text',
                                padding: const EdgeInsets.fromLTRB(8, 4, 8, 4),
                                decoration: BoxDecoration(
                                  borderRadius: const BorderRadius.all(
                                    Radius.circular(8),
                                  ),
                                  color: Colors.grey.shade600,
                                ),
                                mouseCursor: MouseCursor.uncontrolled,
                                child: IconButton(
                                  onPressed: () {
                                    // context.pop();
                                  },
                                  icon: const Icon(
                                    Icons.cleaning_services,
                                    color: Colors.white,
                                    size: 20,
                                  ),
                                ),
                              ),
                              containerColor: Colors.grey,
                              boxShape: BoxShape.circle,
                            ),
                            ButtonAnimat(
                              widgetChild: ElevatedButton.icon(
                                onPressed: () {},
                                icon: const Icon(Icons.add),
                                label: const Text('زیادکردن'),
                              ),
                              containerColor: Colors.blue,
                              colorShadow: Colors.blue,
                              boxShape: BoxShape.rectangle,
                              borderRadius: BorderRadius.circular(8),
                              blurRadius: 0,
                              spreadRadius: 1.5,
                            ),

                            Tooltip(
                              richMessage: const TextSpan(
                                text: 'زیادکردن:',
                                children: [
                                  TextSpan(text: '\n', spellOut: true),
                                  TextSpan(text: 'به‌روار:', spellOut: true),
                                  TextSpan(text: '\n', spellOut: true),
                                  TextSpan(text: '\n'),
                                  TextSpan(text: 'گورین:'),
                                  TextSpan(text: '\n'),
                                  TextSpan(text: 'به‌روار:'),
                                ],
                              ),
                              textAlign: TextAlign.center,
                              ignorePointer: true,
                              enableFeedback: true,
                              preferBelow: false,
                              padding: const EdgeInsets.fromLTRB(8, 4, 8, 4),
                              constraints: const BoxConstraints(minWidth: 200),
                              decoration: BoxDecoration(
                                borderRadius: const BorderRadius.all(
                                  Radius.circular(8),
                                ),
                                color: Colors.green.shade600,
                              ),
                              mouseCursor: MouseCursor.uncontrolled,
                              child: IconButton(
                                onPressed: () {
                                  showMenu(context: context, items: []);
                                },
                                icon: const Icon(Icons.info, size: 20),
                              ),
                            ),
                          ],
                        ),
                      ],
                    ),
                  ),
                ),
              ),
            ],
          ),
        ),
      ),
    );
  }
}
