import 'package:flutter/material.dart';
import 'package:zabino/features/codex_solution/presentation/components/appbar_alert_dailog.dart';
import 'package:zabino/features/codex_solution/presentation/components/button_animate.dart';
import 'package:zabino/features/codex_solution/presentation/components/elevated_bottun_custom.dart';

class ContainerAreaAlertDailog extends StatelessWidget {
  const ContainerAreaAlertDailog({super.key, required this.themedata});

  final ThemeData themedata;

  @override
  Widget build(BuildContext context) {
    return Padding(
      padding: const EdgeInsets.all(92),
      child: Container(
        decoration: BoxDecoration(
          borderRadius: BorderRadius.circular(18),
          color: themedata.colorScheme.surface,
        ),
        child: Padding(
          padding: const EdgeInsets.all(24),
          child: Column(
            children: [
              const AppBarAlertDailog(title: 'ناوچه‌کانی شوفیر'),
              const Spacer(),
              ButtonAnimat(
                widgetChild: ElevatedButton.icon(
                  onPressed: () {},
                  icon: const Icon(Icons.add),
                  label: const Text('زیادکردن'),
                ),
                containerColor: Colors.blue,
                colorShadow: Colors.blue,
                boxShape: BoxShape.rectangle,
                borderRadius: BorderRadius.circular(8),
                blurRadius: 0,
                spreadRadius: 2,
              ),
            ],
          ),
        ),
      ),
    );
  }
}
