import 'package:flutter/cupertino.dart';
import 'package:flutter/material.dart';
import 'package:flutter_riverpod/flutter_riverpod.dart';
import 'package:zabino/features/codex_solution/presentation/components/box_decoration_custom.dart';
import 'package:zabino/features/codex_solution/presentation/provider/text_field_controller.dart';

class TextFieldDropDownCustom extends ConsumerWidget {
  const TextFieldDropDownCustom({
    super.key,
    required this.label,
    required this.prefixIcon,
    this.maxLine = 1,
    this.onTaped,
    required this.controller,
    this.onTapDrapDown,
    this.readOnly = false,
    this.keyboardType = TextInputType.text,
    this.onChange,
  });
  final String label;
  final IconData prefixIcon;
  final int maxLine;
  final TextEditingController controller;
  final Function(String)? onTaped;
  final Function()? onTapDrapDown;
  final Function(String value)? onChange;
  final bool? readOnly;
  final TextInputType? keyboardType;

  final double radius = 16;
  @override
  Widget build(BuildContext context, ref) {
    final state = ref.watch(textFieldControllerProvider);
    final selectedTextFieldName = ref.watch(
      textFieldControllerProvider.select(
        (state) => state.selectedTextFieldName,
      ),
    );
    final manageStateTextField = ref.read(textFieldControllerProvider.notifier);
    return Container(
      decoration: BoxDecorationCustom(state, label),
      child: DropdownMenuFormField(
        alignmentOffset: const Offset(0, 10),
        onSelected: (value) {
          manageStateTextField.setEmptyTextField(controller.text, label);
          onTaped!(label);
        },
        menuStyle: const MenuStyle(
          backgroundColor: WidgetStatePropertyAll(Colors.grey),
          side: WidgetStatePropertyAll(
            BorderSide(color: Colors.white, width: 1.5),
          ),
        ),
        leadingIcon: Icon(prefixIcon, size: 24),
        trailingIcon: (selectedTextFieldName == label && !state.isEmptyText)
            ? GestureDetector(
                onTap: () {
                  controller.text = '';
                  manageStateTextField.setEmptyTextField('', label);
                },
                child: const Icon(Icons.close, color: Colors.red, size: 16),
              )
            : const SizedBox(),
        selectedTrailingIcon:
            (selectedTextFieldName == label && !state.isEmptyText)
            ? GestureDetector(
                onTap: () {
                  controller.text = '';
                  manageStateTextField.setEmptyTextField('', label);
                },
                child: const Icon(Icons.close, color: Colors.red, size: 16),
              )
            : const SizedBox(),
        enableFilter: false,
        label: Padding(
          padding: const EdgeInsets.only(top: 20, bottom: 0),
          child: Text(label),
        ),
        controller: controller,
        inputDecorationTheme: InputDecorationTheme(
          activeIndicatorBorder: BorderSide(style: BorderStyle.none),
          alignLabelWithHint: true,
          filled: true,
          floatingLabelStyle: const TextStyle(fontSize: 12),
          border: OutlineInputBorder(
            borderRadius: BorderRadius.all(Radius.circular(radius)),
            borderSide: const BorderSide(style: BorderStyle.none),
          ),
          focusedBorder: OutlineInputBorder(
            borderRadius: BorderRadius.all(Radius.circular(radius)),
            borderSide: const BorderSide(style: BorderStyle.none),
          ),
          enabledBorder: OutlineInputBorder(
            borderRadius: BorderRadius.all(Radius.circular(radius)),
            borderSide: const BorderSide(style: BorderStyle.none),
          ),
          contentPadding: const EdgeInsets.only(top: 25, bottom: 10),
          isDense: false,
        ),
        width: MediaQuery.widthOf(context) / 2.4,
        menuHeight: 250,
        dropdownMenuEntries: List.generate(growable: false, 50, (index) {
          return DropdownMenuEntry(
            value: index,
            label: 'text $index',
            style: const ButtonStyle(
              side: WidgetStatePropertyAll(
                BorderSide(width: 0.3, color: Colors.white),
              ),
            ),
          );
        }),
      ),
    );
  }
}
