import 'package:flutter/material.dart';
import 'package:zabino/features/codex_solution/presentation/provider/state/text_field_state.dart';
import 'package:zabino/features/codex_solution/presentation/provider/text_field_controller.dart';

InputDecoration InputDecorationCustom(
  double radius,
  String label,
  IconData prefixIcon,
  TextEditingController controller,
  Function()? onTapDrapDown,
  String selectedTextFieldName,
  TextFieldState state,
  TextFieldController manageStateTextField,
) {
  return InputDecoration(
    floatingLabelStyle: const TextStyle(fontSize: 12),
    focusedBorder: OutlineInputBorder(
      borderRadius: BorderRadius.all(Radius.circular(radius)),
      borderSide: const BorderSide(style: BorderStyle.none),
    ),
    enabledBorder: OutlineInputBorder(
      borderRadius: BorderRadius.all(Radius.circular(radius)),
      borderSide: const BorderSide(style: BorderStyle.none),
    ),
    prefixIcon: Icon(prefixIcon, size: 24),

    suffixIcon: onTapDrapDown == null
        ? (selectedTextFieldName == label && !state.isEmptyText)
              ? IconButton(
                  onPressed: () {
                    controller.text = '';
                    manageStateTextField.setEmptyTextField('', label);
                  },
                  icon: const Icon(Icons.close, color: Colors.red, size: 16),
                )
              : null
        : const Icon(
            Icons.keyboard_arrow_down_rounded,
            color: Colors.black,
            size: 16,
          ),

    alignLabelWithHint: true,
    contentPadding: const EdgeInsets.only(top: 25, bottom: 10),
    isDense: true,
    label: Padding(
      padding: const EdgeInsets.only(top: 20, bottom: 0),
      child: Text(label),
    ),
  );
}
