import 'package:flutter/material.dart';
import 'package:flutter_riverpod/flutter_riverpod.dart';
import 'package:go_router/go_router.dart';
import 'package:zabino/core/utils/responsive.dart';
import 'package:zabino/features/codex_solution/data/datasource/text_edit_name.dart';
import 'package:zabino/features/codex_solution/presentation/components/container_add_driver_alert_dailog.dart';
import 'package:zabino/features/codex_solution/presentation/provider/text_field_controller.dart';

class CodexSulotion extends ConsumerWidget {
  const CodexSulotion({super.key});

  @override
  Widget build(BuildContext context, ref) {
    return SafeArea(
      child: Scaffold(
        body: Directionality(
          textDirection: TextDirection.ltr,
          child: Center(
            child: ElevatedButton(
              onPressed: () {
                showDialog(
                  context: context,
                  barrierDismissible: true,
                  builder: (context) {
                    return const ContainerAddDriverAlertDailog();
                  },
                );
              },
              child: const Text('Show Alert'),
            ),
          ),
        ),
      ),
    );
  }
}
