import 'package:flutter/material.dart';

class TextFieldState {
  final bool isEmptyText;
  final bool showRemoveTextIcon;
  final String selectedTextFieldName;
  TextFieldState({
    required this.isEmptyText,
    required this.showRemoveTextIcon,
    required this.selectedTextFieldName,
  });

  TextFieldState copyWith({
    bool? isEmptyText,
    bool? showRemoveTextIcon,
    String? selectedTextFieldName,
  }) {
    return TextFieldState(
      isEmptyText: isEmptyText ?? this.isEmptyText,
      showRemoveTextIcon: showRemoveTextIcon ?? this.showRemoveTextIcon,
      selectedTextFieldName:
          selectedTextFieldName ?? this.selectedTextFieldName,
    );
  }

  @override
  bool operator ==(Object other) {
    if (identical(this, other)) return true;
    return other is TextFieldState &&
        other.isEmptyText == isEmptyText &&
        other.showRemoveTextIcon == showRemoveTextIcon &&
        other.selectedTextFieldName == selectedTextFieldName;
  }

  @override
  int get hashCode =>
      Object.hash(isEmptyText, showRemoveTextIcon, selectedTextFieldName);
}
