import 'package:flutter/material.dart';
import 'package:riverpod_annotation/riverpod_annotation.dart';
import 'package:zabino/features/codex_solution/data/datasource/text_edit_name.dart';
import 'package:zabino/features/codex_solution/presentation/provider/state/text_field_state.dart';
part 'text_field_controller.g.dart';

@riverpod
class TextFieldController extends _$TextFieldController {
  @override
  TextFieldState build() {
    return TextFieldState(
      isEmptyText: true,
      showRemoveTextIcon: false,
      selectedTextFieldName: '',
    );
  }

  void setEmptyTextField(String newValue, String textFieldName) {
    if (newValue.isEmpty) {
      state = state.copyWith(
        isEmptyText: true,
        selectedTextFieldName: textFieldName,
      );
    } else {
      state = state.copyWith(isEmptyText: false);
    }
  }

  void checkEmptyTextField(String value, Key key) {}

  void selectTexField(String textFieldName) {
    state = state.copyWith(selectedTextFieldName: textFieldName);
  }
}
